package gov.va.med.mhv.sm.admin.model;

import gov.va.med.mhv.sm.admin.model.AbstractBaseEntity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "PATIENT_PCMM_ASSIGNMENTS")
public class PatientPCPAssignment extends AbstractBaseEntity {

	private static final long serialVersionUID = 8201368017258992882L;

	@Id
	@Column(name = "PATIENT_PCMM_ASSIGNMENT_ID")
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	private Long id;
	
	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;
	
	@Column(name = "PCMM_ASSIGNMENT_STATUS")
	private String assignmentStatus;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "USER_PATIENT_ID")
	private Long patientId;
	
	@Column(name = "PCMM_PROVIDER_IEN")
	private Long providerIen;
	
	@Column(name = "PCMM_PROVIDER_NAME")
	private String providerName;
	
	@Column(name = "STATION_NUMBER")
	private Long stationNumber;

	public PatientPCPAssignment(){
		this.active=true;
		this.createdDate=new Date();
		this.modifiedDate=new Date();
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public String getAssignmentStatus() {
		return assignmentStatus;
	}

	public void setAssignmentStatus(String assignmentStatus) {
		this.assignmentStatus = assignmentStatus;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}
	
	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Long getProviderIen() {
		return providerIen;
	}

	public void setProviderIen(Long providerIen) {
		this.providerIen = providerIen;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	public Long getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(Long stationNumber) {
		this.stationNumber = stationNumber;
	}
	
}
